/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class CatServerConfig {
    private final File configFile;
    private YamlConfiguration config;
    public boolean keepSpawnInMemory = true;
    public boolean enableSkipEntityTick = true;
    public boolean enableSkipTileEntityTick = false;
    public int worldGenMaxTickTime = 15;
    public List<String> disableForgeGenerateWorlds = Lists.newArrayList((Object[])new String[]{"ExampleCustomWorld"});
    public boolean preventBlockLoadChunk = false;
    public List<Integer> autoUnloadDimensions = Lists.newArrayList((Object[])new Integer[]{99999999});
    public boolean enableRealtime = false;
    public boolean forceSaveOnWatchdog = true;
    public int maxEntityCollision = 8;
    public boolean saveBukkitWorldDimensionId = true;
    public List<String> fakePlayerPermissions = Lists.newArrayList((Object[])new String[]{"essentials.build"});
    public boolean fakePlayerEventPass = false;
    public boolean fixPlayBossSoundToOtherWorld = true;
    public boolean fixLessCrystalRespawnDragon = false;
    public boolean preventPistonPushRail = false;
    public boolean preventPistonPushSlimeBlock = false;
    public boolean limitFastClickGUI = false;
    public boolean enableDynmapCompatible = true;
    public boolean enableCoreProtectModBlockCompatible = true;
    public boolean enableEssentialsNewVersionCompatible = true;
    public boolean enableMythicMobsPatcherCompatible = true;
    public boolean enableWorldEditCompatible = true;
    public boolean enableCitizensCompatible = true;
    public List<String> disableHopperMoveEventWorlds = Lists.newArrayList();
    public boolean defaultInstallPluginSpark = true;
    public boolean waitForgeServerChatEvent = false;
    public boolean securityOpManager = false;
    public boolean securityGameModeManager = false;
    public boolean disableUpdateGameProfile = false;
    public boolean disableFMLHandshake = false;
    public boolean disableFMLStatusModInfo = false;
    public boolean disableAsyncCatchWarn = false;
    public boolean versionCheck = true;

    public CatServerConfig(String file) {
        this.configFile = new File(file);
    }

    public void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration(this.configFile);
        this.keepSpawnInMemory = this.getOrWriteBooleanConfig("world.keepSpawnInMemory", this.keepSpawnInMemory);
        this.enableSkipEntityTick = this.getOrWriteBooleanConfig("world.enableSkipEntityTick", this.enableSkipEntityTick);
        this.enableSkipTileEntityTick = this.getOrWriteBooleanConfig("world.enableSkipTileEntityTick", this.enableSkipTileEntityTick);
        this.worldGenMaxTickTime = this.getOrWriteIntConfig("world.worldGenMaxTick", this.worldGenMaxTickTime);
        this.disableForgeGenerateWorlds = this.getOrWriteStringListConfig("world.disableForgeGenerateWorlds", this.disableForgeGenerateWorlds);
        this.preventBlockLoadChunk = this.getOrWriteBooleanConfig("world.preventBlockLoadChunk", this.preventBlockLoadChunk);
        this.autoUnloadDimensions = this.getOrWriteIntegerListConfig("world.autoUnloadDimensions", this.autoUnloadDimensions);
        this.enableRealtime = this.getOrWriteBooleanConfig("world.enableRealtime", this.enableRealtime);
        this.forceSaveOnWatchdog = this.getOrWriteBooleanConfig("world.forceSaveOnWatchdog", this.forceSaveOnWatchdog);
        this.maxEntityCollision = this.getOrWriteIntConfig("world.maxEntityCollision", this.maxEntityCollision);
        this.saveBukkitWorldDimensionId = this.getOrWriteBooleanConfig("world.saveBukkitWorldDimensionId", this.saveBukkitWorldDimensionId);
        this.fakePlayerPermissions = this.getOrWriteStringListConfig("fakePlayer.permissions", this.fakePlayerPermissions);
        this.fakePlayerEventPass = this.getOrWriteBooleanConfig("fakePlayer.eventPass", this.fakePlayerEventPass);
        this.fixPlayBossSoundToOtherWorld = this.getOrWriteBooleanConfig("vanilla.fixPlayBossSoundToOtherWorld", this.fixPlayBossSoundToOtherWorld);
        this.fixLessCrystalRespawnDragon = this.getOrWriteBooleanConfig("vanilla.fixLessCrystalRespawnDragon", this.fixLessCrystalRespawnDragon);
        this.preventPistonPushRail = this.getOrWriteBooleanConfig("vanilla.preventPistonPushRail", this.preventPistonPushRail);
        this.preventPistonPushSlimeBlock = this.getOrWriteBooleanConfig("vanilla.preventPistonPushSlimeBlock", this.preventPistonPushRail);
        this.limitFastClickGUI = this.getOrWriteBooleanConfig("vanilla.limitFastClickGUI", this.limitFastClickGUI);
        this.enableDynmapCompatible = this.getOrWriteBooleanConfig("plugin.patcher.enableDynmapCompatible", this.enableDynmapCompatible);
        this.enableCoreProtectModBlockCompatible = this.getOrWriteBooleanConfig("plugin.patcher.enableCoreProtectModBlockCompatible", this.enableCoreProtectModBlockCompatible);
        this.enableEssentialsNewVersionCompatible = this.getOrWriteBooleanConfig("plugin.patcher.enableEssentialsNewVersionCompatible", this.enableEssentialsNewVersionCompatible);
        this.enableMythicMobsPatcherCompatible = this.getOrWriteBooleanConfig("plugin.patcher.enableMythicMobsPatcherCompatible", this.enableMythicMobsPatcherCompatible);
        this.enableWorldEditCompatible = this.getOrWriteBooleanConfig("plugin.patcher.enableWorldEditCompatible", this.enableWorldEditCompatible);
        this.enableCitizensCompatible = this.getOrWriteBooleanConfig("plugin.patcher.enableCitizensCompatible", this.enableCitizensCompatible);
        this.disableHopperMoveEventWorlds = this.getOrWriteStringListConfig("plugin.disableHopperMoveEventWorlds", this.disableHopperMoveEventWorlds);
        this.defaultInstallPluginSpark = this.getOrWriteBooleanConfig("plugin.defaultInstall.spark", this.defaultInstallPluginSpark);
        this.waitForgeServerChatEvent = this.getOrWriteBooleanConfig("async.waitForgeServerChatEvent", this.waitForgeServerChatEvent);
        this.securityOpManager = this.getOrWriteBooleanConfig("security.opManager", this.securityOpManager);
        this.securityGameModeManager = this.getOrWriteBooleanConfig("security.gameModeManager", this.securityGameModeManager);
        this.disableUpdateGameProfile = this.getOrWriteBooleanConfig("disableUpdateGameProfile", this.disableUpdateGameProfile);
        this.disableFMLHandshake = this.getOrWriteBooleanConfig("disableFMLHandshake", this.disableFMLHandshake);
        this.disableFMLStatusModInfo = this.getOrWriteBooleanConfig("disableFMLStatusModInfo", this.disableFMLStatusModInfo);
        this.disableAsyncCatchWarn = this.getOrWriteBooleanConfig("disableAsyncCatchWarn", this.disableAsyncCatchWarn);
        this.versionCheck = this.getOrWriteBooleanConfig("versionCheck", this.versionCheck);
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean getOrWriteBooleanConfig(String path, boolean def) {
        if (this.config.contains(path)) {
            return this.config.getBoolean(path);
        }
        this.config.set(path, def);
        return def;
    }

    private int getOrWriteIntConfig(String path, int def) {
        if (this.config.contains(path)) {
            return this.config.getInt(path);
        }
        this.config.set(path, def);
        return def;
    }

    private List<String> getOrWriteStringListConfig(String path, List<String> def) {
        if (this.config.contains(path)) {
            return this.config.getStringList(path);
        }
        this.config.set(path, def);
        return def;
    }

    private List<Integer> getOrWriteIntegerListConfig(String path, List<Integer> def) {
        if (this.config.contains(path)) {
            return this.config.getIntegerList(path);
        }
        this.config.set(path, def);
        return def;
    }
}

